#include	"System_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"Metaclass.h"

template_define(List,Component_def)
template_define(List,Connection_def)

static	char*	class_name = "the system_def";
static	char*	class_type = "System_def";


System_def::System_def(Metaclass* meta)  : (meta)
{
	DEBUG	<< "System_def::System_def(" << meta->oid() << ")\n";

	char*	throwaway = class_name;
	
/**/	my_type = class_type;

	char	buffer[256];
	cout << "What do you call this plant system ? ";	//e.g. esp_plt
	cin >> buffer;		//e.g. esp_plt

	my_name = strdup(buffer);
/**/	my_type = class_type;

	int	no_components;
	cout << "how many components wanted ? ";	//not necessary to be used.
	cin >> no_components;
	the_components = new List(Component_def);
	cout << "for each component, specify its type name\n";
	for (int i=0; i<no_components; i++) {
		cout << "component " << i+1 << " type: ";
		cin >> buffer;
		Component_def* component_def = (Component_def*)meta->make_def_for(buffer);
		the_components->append(component_def);
	};

	int	no_connections;
	cout << "how many connections? ";
	cin >> no_connections;
	the_connections = new List(Connection_def);
	cout <<"only one type of connection is allowed for all connections\n";
	cout << "connection type (A/EConnection)? ";
	cin >> buffer;
	for (i = 0; i < no_connections; i++) {
		Connection_def* connection_def = (Connection_def*)meta->make_def_for(buffer);
		the_connections->append(connection_def);
	};
};

System_def::System_def(char* a_name, List(Component_def)* component_defs,
					 List(Connection_def)* connection_defs)
			: (NULLPTR(Metaclass)) 
{
	DEBUG	<< "System_def::System_def(char* a_name, List(Component_def)* component_defs,\n";
	DEBUG	<< "                       List(Connection_def)* connection_defs)\n";

	my_type = class_type;

	my_name = strdup(a_name);

	the_components = component_defs;
	the_connections = connection_defs;
};

System_def::~System_def()
{
	DEBUG << "System_def::~System_def()\n";
};


List_iterator(Component_def)	System_def::component_def_iter()
{
	DEBUG1	<< "System_def::component_def_iter_def()\n";

	return *new List_iterator(Component_def)(the_components);
};

List_iterator(Connection_def)	System_def::connection_def_iter()
{
	DEBUG1	<< "System_def::connection_def_iter_def()\n";

	return *new List_iterator(Connection_def)(the_connections);
};


void    System_def::description(Metaclass* meta, ostream& s)
{
        s << "System \n";
	s << indent << "-> Component *n = \n";
        meta->describe_def_for("Component", s);
	s << indent << "-> Connection *n = \n";
        meta->describe_def_for("Connection", s);
	indent[strlen(indent-4)] = '\0';
};

template_implement(List,Component_def);
template_implement(List,Connection_def);
