#ifndef SYSTEM_H
#define SYSTEM_H

#include "EKSObject.h"
class	Metaclass;
class	System_def;
class	Component;
class	Connection;
#include	"Time.h"
#include "network.h"
template_define2(Network,Connection,Component);
template_declare(List,Component);
template_declare(List,Connection);


class System : public EKSObject {
protected:
	Network(Connection,Component) system;

	Component*	findnode(char* component_name);
public:
	System(Metaclass* meta, System_def* def);
	~System();

	List(Component)&	components();
	List(Connection)&	connections();
	List(Connection)&	in_connection_for(Component* cmp);
	List(Connection)&	out_connection_for(Component* cmp);
	List(Component)&	up_stream_node_for(Component* cmp); 	//anti flow direction.
	List(Component)&	down_stream_node_for(Component* cmp);	//flow direction.

virtual	void			execute();
};
#endif
