#include 	"Mixed_vector.h"
#include 	"EKS.h"

static	Dimension* null = new Dimension(0);

Mixed_vector::Mixed_vector(int a)
{
	no = a;
	Dimension* v = new Dimension[a];
	vec = new Dimensionp[a];
	for(int i=0; i<a; i++) vec[i] = &v[i];
};

Mixed_vector::Mixed_vector()
{
	no = 0;
	vec = NULLPTR(Dimensionp);
};

Mixed_vector& Mixed_vector::operator=(Mixed_vector& arg)
{
	if(this==&arg) return (*this);
	no = arg.no;
	vec = new Dimensionp[no];
	for(int i=0; i<no; i++) vec[i] = arg[i];
	return *this;
};

Mixed_vector::~Mixed_vector()
{
	delete vec;
};

int Mixed_vector::size()
{
	return no;
};

Dimension*& Mixed_vector::elem(int i)
{
	return vec[i];
};

Dimension*& Mixed_vector::operator[](int i)
{
	if(i<0 || i>=no) {
		cerr <<"subscript out of range\n";
		return null;
	}
	return vec[i];
};
