#ifndef CONNECTION_H
#define CONNECTION_H

#include "EKSObject.h"
#include "Component.h"
class	Metaclass;
class	Connection_def;

class Connection : public EKSObject {
private:
friend	class System;
	Component*	the_source;
	Component*	the_target;
	void		assign_source(Component* src);
	void		assign_target(Component* tgt);
protected:
	char*		the_source_name;
	char*		the_target_name;
public:
	Connection(Metaclass* meta, Connection_def* def);
	~Connection();

	Connection& operator=(Connection& conns);	// shallow copy
	Component*	source() { return the_source; };
	Component*	target() { return the_target; };
	char*		source_name() { return the_source_name; };
	char*		target_name() { return the_target_name; };
	char*		my_name() { return name(); };
};

#endif
