#include	"building/Surface_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"transport/Polygon.h"
#include	"transport/Vertex.h"
#include	"infrastructure/Metaclass.h"


Finish	Surface_def::get_finish()
{
	float	emis, refl, rough;
	cout << "Surface finish:\n    emisivity ";
	cin >> emis;
	cout << "    reflectivity ";
	cin >> refl;
	cout << "    roughness ";
	cin >> rough;
	return Finish(emis, refl, rough);
};

Polygon*	Surface_def::get_polygon()
{
	int	n, i = 0;
	cout << "Surface geometry:\n  how many <x,y,z> vertices";
	cin >> n;

	List(Vertex) vl;
	while (i < n) {
		float x, y, z;
		cout << "    " << i++ << ": ";
		cin >> x >> y >> z;
		Vertex* v = new Vertex(x,y,z);
		vl.append(v);
	};
	return new Polygon(vl);
};

Surface_def::Surface_def(Metaclass* meta)  : X_def(meta), the_finish(get_finish())
{
	DEBUG	<< "Surface_def::Surface_def(" << meta->oid() << ")\n";

	the_polygon = get_polygon();
};

Surface_def::Surface_def(Finish& fin, Polygon* poly)
			: X_def(), the_finish(fin)
{
	DEBUG	<< "Surface_def::Surface_def(Finish& fin, Polygon* poly)\n";

	the_polygon = new Polygon(*poly);
};

Surface_def::Surface_def(APL* theAPL) : X_def(theAPL), the_finish(0,0,0)
{};

Surface_def::~Surface_def()
{
	DEBUG << "Surface_def::~Surface_def()\n";

	delete the_polygon;
};


Polygon*	Surface_def::polygon()
{
	DEBUG1	<< "Polygon*	Surface_def::polygon()\n";

	return the_polygon;
};

Finish&	Surface_def::surface_finish()
{
	DEBUG1	<< "Polygon*	Surface_def::surface_finish()\n";

	return the_finish;
};
