#ifndef SURFACE_H
#define SURFACE_H

/* Contains a finish pointer and a polygon pointer. */

#include	"transport/Finish.h"
#include	"infrastructure/EKSObject.h"
class	Metaclass;
class	Surface_def;
class	Polygon;


class Surface : public EKSObject {
protected:
	Polygon*	the_polygon;
        Finish		the_finish;		// type of finish

	Surface(Metaclass* meta, Surface_def* def);
	Surface(Finish* fin, Polygon* poly);
	Surface(Surface& surf);
	Surface(APL* theAPL);
	~Surface();

public:
	Surface& operator=(Surface& surf);	// deep copy of poly

	Finish		finish();
        Polygon*	polygon();
};

#endif

