#include	"building/Surface.h"

#include	"transport/Polygon.h"
#include	"building/Surface_def.h"


Surface::Surface(Metaclass* meta, Surface_def* def)
			: EKSObject(meta), the_finish(def->surface_finish())
{
	DEBUG << "Surface::Surface(Metaclass* meta, Surface_def* def)\n";

	the_polygon = def->polygon();
}

Surface::Surface(Finish* fin, Polygon* poly)
			: EKSObject(NULLPTR(Metaclass)), the_finish(*fin)
{
	DEBUG << "Surface::Surface(Finish* fin, Polygon* poly)\n";

	the_polygon = poly;
};

Surface::Surface(Surface& surf)
			: (NULLPTR(Metaclass)), the_finish(surf.the_finish)
{
	DEBUG << "Surface::Surface(Surface& surf)\n";

        the_polygon=surf.the_polygon;
}

Surface::Surface(APL* theAPL)  : EKSObject(theAPL), the_finish(theAPL)
{};

Surface::~Surface()
{
	DEBUG	<< "Surface::~Surface()\n";

	delete the_polygon;
};


Surface& Surface::operator=(Surface& surf)
{
	DEBUG1 << "Surface::operator=(Surface& surf)\n";	

	if (this==&surf) return (*this);

        the_finish=surf.the_finish;
        the_polygon=new Polygon(*surf.the_polygon);
 
       return (*this);
}

Finish	Surface::finish()
{
	DEBUG1	<< "Finish	Surface::finish()\n";

	return the_finish;
};

Polygon*	Surface::polygon()
{
	DEBUG1	<< "Polygon*	Surface::polygon()\n";

	return the_polygon;
};
