#include	"building/Space.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
#include	"building/Space_def.h"

Type*	Space_Type_pointer;


Space::Space(Metaclass* meta, Space_def* def)  : EKSObject(meta)
{
	DEBUG << "Space::Space(" << meta->oid() << ", " << def->oid() ")\n";

        directType(TYPE_OF(Space));

        theVolume = def->volume();
};

Space::Space(Space& aSpace)  : EKSObject(aSpace.metaclass)
{
	DEBUG << "Space::Space(" << aConstruction->oid() << ")\n";

        directType(TYPE_OF(Space));

	theVolume = aSpace.theVolume;
};

Space::Space(APL* theAPL) : EKSObject(theAPL), theVolume(theAPL)
{};

Space::~Space()
{
	DEBUG << "Space::~Space()\n";
};


Space& Space::operator=(Space& aSpace)
{
        DEBUG1 << "Space::operator=(" << aSpace->oid() << ")\n";

        if(this==&aSpace) return (*this);

        theVolume = aSpace.theVolume;

        return (*this);
};
