#ifndef	LAYER_DEF_H
#define	LAYER_DEF_H

#include	"dimensions/Length.h"
#include	"transport/Substance.h"
#include	"context/X_def.h"
class	Metaclass;

extern	Type*	Layer_def_Type_pointer;


class Layer_def : public X_def {
protected:
	Substance	the_substance;
	Length		the_thickness;

	virtual char*	get_material();
	virtual float	get_thickness();

friend	Construction_def;
	Layer_def(Metaclass* meta);
	Layer_def(Substance& sub, Length thk);
	Layer_def(APL* theAPL);
	~Layer_def();
public:
	Type*	getDirectType();
	Substance	substance();
	Length		thickness();
};


inline
Type*	Layer_def::getDirectType()
{
	return TYPE_OF(Layer_def);
};
#endif
