#ifndef LAYER_H
#define LAYER_H

#include	"dimensions/Length.h"
#include	"transport/Substance.h"
#include	"infrastructure/EKSObject.h"
class	Metaclass;
class	Layer_def;

extern	Type*	Layer_Type_pointer;

/* a thermal layer definition: a layer comprises one or more substance
 * which are homogeneous perpendicular to the bounding surfaces but may
 * vary parallel to these surfaces e.g. a masonry leaf, tiled wall
 */


class Layer : public EKSObject {
protected:
	Substance	theSubstance;  //substance filling homogeneous layer
	Length		theThickness;  //
friend	Construction;
	Layer(Metaclass* meta, Layer_def* def);
	Layer(Layer& lyr);
	Layer(APL* theAPL);
	~Layer();
public:
	Type*	getDirectType();
	
	Layer&	operator=(Layer& lyr);

	Length			thickness();
	Substance		substance();
};


inline
Type*	Layer::getDirectType()
{
	return TYPE_OF(Layer);
};
#endif
