#include	"building/Layer.h"

#include	"infrastructure/Metaclass.h"
#include	"building/Layer_def.h"

Type*	Layer_Type_pointer;
 

Layer::Layer(Metaclass* meta, Layer_def* def)
			: EKSObject(meta),
			  theSubstance(def->substance()),
			  theThickness(def->thickness())
{
	DEBUG << "Layer::Layer(Metaclass* meta, Layer_def* def)\n";

	directType(TYPE_OF(Layer));
};
 
Layer::Layer(Layer& lyr) : EKSObject(lyr.metaclass),
			   theSubstance(lyr.theSubstance),
			   theThickness(lyr.theThickness)
{
	DEBUG << "Layer::Layer(Layer& lyr)\n";

	directType(TYPE_OF(Layer));
}

Layer::Layer(APL* theAPL)  : EKSObject(theAPL),
					theSubstance(theAPL), theThickness(theAPL)
{};

Layer::~Layer()
{
	DEBUG << "Layer::~Layer()\n";
};

 
Layer& Layer::operator=(Layer& lyr)
{
	DEBUG1 << "Layer::operator=\n";

	if (this==&lyr) return (*this);

	theSubstance = lyr.theSubstance;
        theThickness = lyr.theThickness;

        return (*this);
};


Length	Layer::thickness()
{
	DEBUG1 << "Length  Layer::thickness()\n";

	return	theThickness;
};

Substance	Layer::substance()
{
	DEBUG1 << "Substance  Layer::substance()\n";

	return	theSubstance;
};
