#ifndef CONSTRUCTION_H
#define CONSTRUCTION_H
 
#include	"dimensions/Length.h"
#include	"infrastructure/EKSObject.h"
class	Metaclass;
class	Construction_def;

extern	Type*	Construction_Type_pointer;


class Construction : public EKSObject {
protected:
	Length		the_thickness;

	Construction(Metaclass* meta, Construction_def* def);
	Construction(Construction& c);
	Construction(APL* theAPL);
	~Construction();
public:
	Type*	getDirectType();
 
	Construction& operator=(Construction& constr);	// shallow copy

	Length			thickness();
};
 

inline
Type*	Construction::getDirectType()
{
	return TYPE_OF(Construction);
};

inline
Length	Construction::thickness()
{
        return the_thickness;
};

#endif
