#include        "building/Construction.h"

#include        "infrastructure/Metaclass.h"
#include        "building/Construction_def.h"

Type*   Construction_Type_pointer;


Construction::Construction(Metaclass* meta, Construction_def* def)
                        : EKSObject(meta)
 { 
        DEBUG << "Construction::Construction(" << meta->oid() << ", " << def->oid() ")\n";

        directType(TYPE_OF(Construction));

        the_thickness = def->thickness();
};

Construction::Construction(Construction& aConstruction)
                                : EKSObject(aConstruction.metaclass)
{ 
        DEBUG << "Construction::Construction(" << aConstruction->oid() << ")\n";

        directType(TYPE_OF(Construction));

        the_thickness = aConstruction.the_thickness;
};

Construction::Construction(APL* theAPL) : EKSObject(theAPL), the_thickness(theAPL)
{};

Construction::~Construction()
{
        DEBUG << "~Construction()\n";
};


Construction& Construction::operator=(Construction& constr)
{
        DEBUG1 << "Construction::operator=(" << constr->oid() << ")\n";

        if(this==&constr) return (*this);

        the_thickness = constr.the_thickness;

        return (*this);
};
