#include	"building/Building.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
#include	"building/Building_def.h"

Type*	Building_Type_pointer;


Building::Building(Metaclass* meta, Building_def* def)
				: EKSObject(meta)
{
	DEBUG	<< "Building::Building(" << meta->oid() << ", " << def->oid() << ")\n";

	name(def->name());
        directType(TYPE_OF(Building));

	theVolume = def->volume();
};

Building::Building(Building& bld) : EKSObject(bld.metaclass)
{
	DEBUG	<< "Building::Building(" << bld.oid() << ")\n";

        directType(TYPE_OF(Building));

	theVolume = bld.volume();
};

Building::Building(APL* theAPL) : EKSObject(theAPL), theVolume(theAPL)
{};

Building::~Building()
{
	DEBUG << "Building::~Building()\n";
};

Building& Building::operator=(Building& bld)
{
        DEBUG1 << "Building::operator=(" << bld->oid() << ")\n";

        if(this==&bld) return (*this);

        theVolume = bld.theVolume;

        return (*this);
};

