#include	"building/AirVolume.h"

#include	"dimensions/Volume.h"
#include	"infrastructure/Metaclass.h"
#include	"building/AirVolume_def.h"

static	char*	class_name = "the_air_volume";
Type*	AirVolume_Type_pointer;


AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def) : EKSObject(meta)
{
	DEBUG	<< "AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume));

	theVolume = def->volume();
};

AirVolume::AirVolume(Volume vol)  : EKSObject(NULLPTR(Metaclass)),
						  theVolume(vol)
{
	DEBUG	<< "AirVolume::AirVolume(Volume vol, Substance& sub)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume));
};

AirVolume::AirVolume(AirVolume& airvol)
			: EKSObject(airvol.metaclass), theVolume(airvol.theVolume)
{
	DEBUG	<< "AirVolume::AirVolume(AirVolume& airvol)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume));
};

AirVolume::AirVolume(APL* theAPL) : EKSObject(theAPL), theVolume(theAPL)
{};

AirVolume::~AirVolume()
{
	DEBUG	<< "AirVolume::~AirVolume()\n";
};


AirVolume&	AirVolume::operator=(AirVolume& airvol)
{
	DEBUG1	<< "AirVolume&   AirVolume::operator=(AirVolume& airvol)\n";

	if (&airvol == this)   return (*this);

	theVolume = airvol.theVolume;

	return (*this);
};


Volume		AirVolume::volume()
{
	DEBUG1	<< "Volume   AirVolume::volume()\n";

	return theVolume;
};

